function mat_rs = resize(mat, Nx, Nz, interp)
%RESIZE     Resize a matrix using interp2.
%
% DESCRIPTION:
%       Resize a matrix using interp2
%
% USAGE:
%       mat_rs = resize(mat, Nx, Nz)
%
% INPUTS:
%       mat         - matrix to resize
%       Nx          - desired number of pixels in the x (column) direction
%       Nz          - desired number of pixels in the z (row) direction
%
% OPTIONAL INPUTS:
%       interp      - interpolation mode used by interp2 
%                     (default = 'linear')
%
% OUTPUTS:
%       mat_rs      - resized matrix
%
% ABOUT:
%       author      - Bradley Treeby
%       date        - 8th July 2009
%       last update - 17th July 2009
%       
% This function is part of the k-Wave Toolbox (http://www.k-wave.org)
% Copyright (C) 2009, 2010 Bradley Treeby and Ben Cox
%
% See also interp2

% This file is part of k-Wave. k-Wave is free software: you can
% redistribute it and/or modify it under the terms of the GNU Lesser
% General Public License as published by the Free Software Foundation,
% either version 3 of the License, or (at your option) any later version.
% 
% k-Wave is distributed in the hope that it will be useful, but WITHOUT ANY
% WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
% FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
% more details. 
% 
% You should have received a copy of the GNU Lesser General Public License
% along with k-Wave. If not, see <http://www.gnu.org/licenses/>.

% check the input is two-dimensional
if numDim(mat) ~= 2
    error('Input matrix must be two-dimensional');
end

% check for interpolation mode input
if nargin < 4
    interp = 'linear';
end

% extract the actual number of pixels from the size of the matrix
[Nz_input Nx_input] = size(mat);

% check the size is different to the input size
if Nx_input ~= Nx || Nz_input ~= Nz 

    % resize the input matrix to the desired number of pixels
    mat_rs = interp2(0:1/(Nx_input - 1):1, (0:1/(Nz_input - 1):1)', mat, 0:1/(Nx - 1):1, (0:1/(Nz - 1):1)', interp);
    
else
    mat_rs = mat;
end